definition module deltaTimer

import deltaIOSystem
from ioTypes import IOState


// TicksPerSecond :== 18

// ::	CurrentTime
// :==	(	!Int,		// hours		(0-23)
//			!Int,		// minutes		(0-59)
//			!Int		// seconds		(0-59)
//		);
// ::	CurrentDate
//	:==	(	!Int,		// year
//			!Int,		// month		(1-12)
//			!Int,		// day			(1-31)
//			!Int		// day of week	(1-7, Sunday=1, Saturday=7)
//		);

/*	Opening and closing of timers. In case already a timer exists with the
	given new TimerId, the timer is not opened. Closing the timer with an
	unknown TimerId has no effect. */
// OpenTimer :: !(TimerDef *s (IOState *s)) !(IOState *s) -> IOState *s
// CloseTimer :: !TimerId !(IOState *s) -> IOState *s


// EnableTimer  :: !TimerId !(IOState s) -> (IOState s)
// DisableTimer :: !TimerId !(IOState s) -> (IOState s)
// ChangeTimerFunction :: !TimerId !(TimerFunction *s (IOState *s)) !(IOState *s) -> IOState *s
// SetTimerInterval :: !TimerId !TimerInterval !(IOState *s) -> IOState *s


/*	GetCurrentTime and GetCurrentDate return the current time and date. */
// GetCurrentTime :: !(IOState s) -> (!CurrentTime, !IOState s)
// GetCurrentDate :: !(IOState s) -> (!CurrentDate, !IOState s)


/*	Wait/UWait suspend the interaction for TimerInterval ticks. */
// Wait  :: TimerInterval x -> x
// UWait :: TimerInterval *x -> *x


/*	Returns the TimerInteval that should elaps between blinks of e.g.
	a cursor. This interval can change during the interaction! */
// GetTimerBlinkInterval :: !(IOState s) -> (!TimerInterval, !IOState s)


from Timer1 import TicksPerSecond,
                   CurrentTime, CurrentDate,
                   OpenTimer, CloseTimer,
				   ChangeTimerFunction, SetTimerInterval,
				   GetTimerBlinkInterval,
				   EnableTimer, DisableTimer,
				   GetCurrentTime, GetCurrentDate,
				   Wait, UWait
				   
